local brain = require "brains/loneraibrain"

local assets =
    {
        Asset("ANIM", "anim/lonerai.zip"),
    }

local prefabs =
{
    "warsaw939",
    "soul",
    "fireball",
	"crystal",
	"battery",
	"shell",
	"stoneflower",
	"moonlight",
}
	
	
	SetSharedLootTable( 'lonerai',
{
    {'cookedmeat',  .5},
    {'warsaw939',     1.0},
    {'warsaw939',     1.0},
	{'warsaw939',     1.0},
    {'warsaw939',     .80},
	{'warsaw939',     .80},
    {'warsaw939',     .6},
	{'warsaw939',     .6},
    {'warsaw939',     .4},
	{'warsaw939',     .4},
    {'warsaw939',     .2},	
    {'healingsalve', .25},
	{'bandage', .5},
	{'goldnugget',  1.0},
	{'goldnugget',  .75},
	{'goldnugget',  .25},
	{'soul',  .2},
	{'fireball',  .2},
	{'crystal',  .25},
	{'battery',  .25},
	{'shell',  .15},
	{'stoneflower',  .25},
	{'moonlight',  .15},
})


	local function ontalk(inst, script)
    inst.SoundEmitter:PlaySound("loner/characters/loner/talk_LP")
end

local function OnAttacked(inst, data)
    local attacker = data and data.attacker
	if attacker then
		if inst.components.combat:CanTarget(attacker) and not attacker:HasTag("loner") then
			inst.components.combat:SetTarget(attacker)

			inst.components.combat:ShareTarget(attacker, 100, function(dude)
				return dude:HasTag("lonerai")	
			end, 20)
		end
	end
end

local function ShouldAcceptItem(inst, item)
    if item.components.equippable ~= nil and item.components.equippable.equipslot == EQUIPSLOTS.HEAD then
        return true
    elseif item.components.edible ~= nil then
        local foodtype = item.components.foodtype
        if item.components.edible.foodtype == "ELEMENTAL" then
            return inst.components.follower.leader == nil or inst.components.follower:GetLoyaltyPercent()
        
        end
        return true
    end
end


local function OnGetItemFromPlayer(inst, giver, item)
     if item.components.edible and item.components.edible.foodtype == "ELEMENTAL" then
       if inst.components.combat.target and inst.components.combat.target == giver then
                inst.components.combat:SetTarget(nil)
             elseif giver.components.leader and (giver:HasTag("loner") or giver:HasTag("mithrarin") or giver:HasTag("boomerangbuilder") or giver:HasTag("dismantler") or giver:HasTag("fireblooded")) then
                inst.SoundEmitter:PlaySound("dontstarve/common/makeFriend")
                giver.components.leader:AddFollower(inst)
                inst.components.follower:AddLoyaltyTime (TUNING.PIG_LOYALTY_MAXTIME) 
            end
        end
end


local function NormalRetargetFn(inst)
        return FindEntity(inst, 22, function(guy)
                return (guy:HasTag("monster") or guy:HasTag("USS") or guy:HasTag("bandit")) and guy.components.health and not (guy:HasTag("stalker") or guy.components.health:IsDead()) 
                and inst.components.combat:CanTarget(guy)
        end, nil, {"bearded", "loner","freedom", "duty", "mithrarin", "truce", "boomerangbuilder", "dismantler", "fireblooded", "clearsky", "player"}, nil)
end

local function KeepTargetFn(inst, target)
if target:HasTag("loner") then
			inst.components.combat.target = nil 
	end
    return inst.components.combat:CanTarget(target)
end

local function RetargetFn(inst)
    local invader = nil
    invader = FindEntity(inst, 25, function(guy)
        return guy:HasTag("shadowboss") or guy:HasTag("animal")
    end)
	    return invader
end

local function weapondropped(inst)
    inst:Remove()
end


local function common()

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddPhysics()
    local physics = inst.entity:AddPhysics()
	local sound = inst.entity:AddSoundEmitter()
	local shadow = inst.entity:AddDynamicShadow()

	inst.Transform:SetFourFaced()
	
	inst.DynamicShadow:SetSize(1.5, .75)
		
	inst:AddTag("scarytoprey")
	inst:AddTag("loner")
	inst:AddTag("lonerai")
	inst:AddTag("ai")
	inst:AddTag("beefalo")
	inst:AddTag("character")
	inst:AddTag("amphibious")
	
	MakeCharacterPhysics(inst, 75, .5)

	
	inst.AnimState:SetBank("wilson")
    inst.AnimState:SetBuild("lonerai")
	inst.AnimState:Hide("hat_hair")
    inst.AnimState:Hide("ARM_carry")
    inst.AnimState:Hide("hat")
    inst.AnimState:PlayAnimation("idle")
		
	
	inst:AddComponent("eater")  
	inst.components.eater:SetElemental()
	local selfeater = inst.components.eater
	local old = selfeater.Eat
	function inst.components.eater:Eat(food)
		if selfeater:CanEat(food) then
			if food.components.edible.sanityvalue < 0 then
				food.components.edible.sanityvalue = 0
			end
			if food.components.edible.healthvalue < 0 then
				food.components.edible.healthvalue = 0
			end
		end
		return old(selfeater, food)
	end
		
	inst:AddTag("notraptrigger")
	
	inst:AddComponent("locomotor")
    inst.components.locomotor.runspeed = 6
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.fasteronroad = true
    inst.components.locomotor:SetTriggersCreep(true)
	

    inst:SetStateGraph("SGlonerai")
	local brain = require "brains/loneraibrain"
	inst:SetBrain(brain)
	
	inst:AddComponent("health")
	inst.components.health:SetAbsorptionAmount(0.7)
	inst.components.health:SetMaxHealth(175)
    inst.components.health:StartRegen(3, 60)
	inst.components.health.fire_damage_scale = 0
	
	inst:AddComponent("inventory")
	inst:AddComponent("knownlocations")
	
	inst.weapon = SpawnPrefab( "wand_l" )
	inst.weapon.components.inventoryitem:SetOnDroppedFn(weapondropped)
	


		inst.components.inventory:Equip( inst.weapon )

		
	inst:AddComponent("trader")
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)
    inst.components.trader.onaccept = OnGetItemFromPlayer
	
	inst:AddComponent("talker")
    inst.components.talker.fontsize = 30
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(255/255, 255/255, 0/255)
    inst.components.talker.offset = Vector3(0,-400,0)
	inst.components.talker.ontalk = ontalk
	
	inst:AddComponent("follower")
	inst.components.follower.maxfollowtime =  99999999
	
	inst:AddComponent("leader")
	
	
	inst:AddComponent("combat")
	inst.components.combat:SetDefaultDamage(20)
    inst.components.combat:SetAttackPeriod(2)
    inst.components.combat:SetRange(22)
    inst.components.combat.hiteffectsymbol = "torso"
	inst.components.combat:SetRetargetFunction(2, RetargetFn)
    inst.components.combat:SetKeepTargetFunction(KeepTargetFn)
	inst.components.combat:SetRetargetFunction(3, NormalRetargetFn)
	
	inst:AddComponent("lootdropper")
    inst.components.lootdropper:SetChanceLootTable('lonerai')
	
	inst:AddComponent("waterproofer")
	
	
	inst:AddComponent("inspectable")

    inst:ListenForEvent("attacked", OnAttacked)
		
	return inst
	
end

return 	Prefab("common/lonerai", common, assets)

